{
    This file is part of RA3701Control

    RACAL RA3701 Control program

    Copyright (C) 2025,2026 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.

                                   * * *
    Allows to enter the starting test number - Currently not used
}

unit uenttestno;

{$mode objfpc}{$H+}

interface

uses
    Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
    StdCtrls;

type

    { TFEntTestNo }

    TFEntTestNo = class(TForm)
        BOK: TButton;
        EDTESTNO: TEdit;
        procedure BOKClick(Sender: TObject);
        procedure EDTESTNOChange(Sender: TObject);
        procedure FormCreate(Sender: TObject);
        procedure FormShow(Sender: TObject);
    private
        { private declarations }
    public
        { public declarations }
    end;

var
    FEntTestNo: TFEntTestNo;
    TestNum: integer;

// For i18n
resourcestring
  ENTERTESTNO = 'Enter test #';
  ENTERSTARTTESTNO = 'Enter start test #';


implementation

{ TFEntTestNo }

uses ura3701;

procedure TFEntTestNo.BOKClick(Sender: TObject);
begin
  if TryStrToInt(EDTESTNO.Text, TestNum) then begin
    OKPressed := TRUE;
  end else begin
    EDTestNo.Font.Color := clRed;
  end;
end;

procedure TFEntTestNo.EDTESTNOChange(Sender: TObject);
begin
  EDTestNo.Font.Color := clBlack;
end;

procedure TFEntTestNo.FormCreate(Sender: TObject);
begin
  FaultFindingBite := (Sender = RA3701.MFFBITE);
end;

// Setup when shown
procedure TFEntTestNo.FormShow(Sender: TObject);
begin
  if FaultFindingBITE then
    FEntTestNo.Caption := ENTERTESTNO
  else begin
    FEntTestNo.Caption := ENTERSTARTTESTNO;
    EDTESTNO.Text := '001';
  end;
  EDTESTNO.SetFocus;
end;

initialization
    {$I uenttestno.lrs}

end.

