{
    This file is part of RA3701Control

    RACAL RA3701 Control program

    Copyright (C) 2025,2026 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.

                                   * * *

    MENU Display routine !NOT YET COMPLETED!
}

unit umenu;

{$mode ObjFPC}{$H+}

{$INCLUDE defines.inc}

interface

uses
  Classes, SysUtils;

{$IFDEF RA3701MENUS}
const
// A reply of the MA3700 controller menu.
// Not finished and maybe it will not be never finished.

// TOP MENU
TopMenu: array[1..6,1..4] of string[20] = (
//              ('12345|12345','12345|12345', '12345|12345','12345|12345'),
                ('FREQ |SWEEP',' CHAN| SCAN', '  ANT|  SEL',' PBND| TUNE'),
                ('ERASE|CHANS',' SET | MODES','  SET | FSK','SUB  |OCT  '),
                ('UNIT |TEST ',' SEL |TEST ', 'FACT |TEST ',' SHOW|FAULT'),
                ('TUNE |LIST ',' BW  | LIST', ' AGC | LIST','     |     '),
                ('DIV  |MASTR',' RF  | AMP ', ' COR | SEL ',' DISP|     '),
                (' BW  |     ','SERIAL|PORTS',' FREQ|  RES',' S/W |  ID '));

MenuLevel1_1: array[1..5] of string[20] = (
                 'Enter Start Freq.',
                 'Enter Stop Freq.',
                 'Enter Step Size',
                 'Enter Sweep Rate',
                 'Stop On COR');
MenuLevel1_2: array[1..4] of string[20] = (
                  'Enter Start Channel',
                  'Enter Stop Channel',
                  'Enter Dwell Time',
                  'Stop On COR');
MenuLevel1_3: string[20] = 'Enter Antenna (0-15)';

MenuLevel1_4: array[1..2] of string[40] = (
                   'Passband %02.2f KHz| INC  DEC   SEL',
                   'PBND|%02.2fKHz');
MenuLevel2_1: array[1..2] of string[40] = (
                   'Change all scan flgs| SET CLEAR  NO',
                   'Erase All Channels| YES  NO');
MenuLevel2_2: string[40] = 'Mode settings!*LAST* PRESET';

MenuLevel2_3: string[40] = 'Printer set up|POLARITY SOURCE EXIT';

MenuLevel2_3_1: string[40] = 'Printer polarity| *NORM*     INV';

MenuLevel2_3_2: string[40] = 'Printer source| *NON-DIV*  DIV';

// ...and many more other - TBD (maybe)
{$ENDIF}


procedure DisplayTopMenu(MenuLevel: integer);

implementation

uses ura3701;

// Display RA3701 top menu for the required level in the right display.
// See RA3700 Operators Mnual page 3-2
procedure DisplayTopMenu(MenuLevel: integer);

var i,p: integer;
    st, L1,L2: string;
    msline1: array[1..4] of string[10];
    msLine2: array[1..4] of string[10];

begin
  {$IFDEF RA3701MENUS}
  for i := 1 to 4 do begin
    st := TopMenu[MenuLevel,i];
    p := pos('|',st);
    if p > 0 then begin
      msLine1[i] := Copy(st,1,p-1);
      msLine2[i] := Copy(st,p+1);
    end else begin
      msLine1[i] := st;
      msLine2[i] := '';
    end;
    FmtStr(L1,'%-5S%-5S%-5S%-5S',[msLine1[1],msLine1[2],msLine1[3],msLine1[4]]);
    FmtStr(L2,'%-5S%-5S%-5S%-5S',[msLine2[1],msLine2[2],msLine2[3],msLine2[4]]);
    RA3701.LBDISPLINE1.Caption := L1;
    RA3701.LBDISPLINE2.Caption := L2;
  end;
  {$ELSE}
  RA3701.LBDISPLINE1.Caption := MENUNOTIMPLL1;
  RA3701.LBDISPLINE2.Caption := MENUNOTIMPLL2;
  RA3701.MsgToShow := PRESSRCLTOCONT;
  {$ENDIF}
end;

end.

