{
    This file is part of SkantiControl

    Skanti TRP8000 series control program (CU8000 control unit)
    This program was developed for a CU8000 control unit marked
    TRP 8255 S R GB1. May work or not with other units.

    Copyright (C) 2012-2025 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/.


    Help --> Manual menu item handling
}

unit UMAN;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  GetText;

type

  { TFMAN }

  TFMAN = class(TForm)
    BOK: TButton;
    MANMEMO: TMemo;
    procedure BOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  FMAN: TFMAN;
  OW, OH, OFH: integer;

implementation

uses Skanti;

{$R *.lfm}

{ TFMAN }

// 'OK' button handling
procedure TFMAN.BOKClick(Sender: TObject);
begin
  FMan.Hide;
end;

// When creating form, load manual in the MANMEMO memo handling i18n
procedure TFMAN.FormCreate(Sender: TObject);

var Lang: string = '';
    FallbackLang: string = '';

begin
  // See if there is an internationalization for the manual

  // Read system language
  GetLanguageIDs(Lang, FallbackLang);
  Lang := copy(Lang,1,2);

  // Check if system language is overridden by a command line switch
  if (ParamCount() = 1) and (Pos('--lang', ParamStr(1)) <> 0) then
    Lang := Copy(ParamStr(1),8,2);
  if (ParamCount() = 2) and (Pos('-l',ParamStr(1)) <> 0) then
    Lang := ParamStr(2);

  if FileExists(DocDir+'Manual-'+Lang+'.txt') then
    // Read in the translated manual
    MANMEMO.Lines.LoadFromFile(DocDir+'Manual-'+Lang+'.txt')
  else
    // Read in the english text version of the manpage
    MANMEMO.Lines.LoadFromFile(DocDir+'Manual-en.txt');

  // Save starting width, height & font height
  OW := FMAN.Width;
  OH := FMAN.Height;
  OFH := MANMEMO.Font.Height;
end;

// When showing form, scale it
procedure TFMAN.FormShow(Sender: TObject);

var NewFontHeight: integer;

begin
  NewFontHeight := (OFH * FontMagn) div 100;
  MANMEMO.Font.Height := NewFontHeight;
  FMAN.Width := (OW * FontMagn) div 100;
  FMAN.Height := (OH * FontMagn) div 100;
  FMAN.Left := (Screen.Width-FMAN.Width) div 2;
  FMAN.Top := (Screen.Height-FMAN.Height) div 2;
end;

end.

