{
    This file is part of RA1792Control

    RACAL RA1792 Control program

    Copyright (C) 2014-2022 G. Perotti, I1EPJ, i1epj@aricasale.it

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/.
}

unit umanager;

{$mode objfpc}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  FileCtrl, Buttons, StdCtrls, urename;

type

  { TUMGR }

  TUMGR = class(TForm)
    BDONE: TButton;
    TFLB: TFileListBox;
    SPREN: TSpeedButton;
    SPDEL: TSpeedButton;
    procedure BDONEClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SPDELClick(Sender: TObject);
    procedure SPRENClick(Sender: TObject);
    procedure TFLBSelectionChange(Sender: TObject; User: boolean);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  UMGR: TUMGR;

implementation

uses uRA1792;

{ TUMGR }

procedure TUMGR.BDONEClick(Sender: TObject);
begin
  UMGR.Hide;
  if UMGR.Tag = 1 then uRA1792.RA1792.LoadChannelsDir;
end;

procedure TUMGR.FormActivate(Sender: TObject);
begin
  SPREN.Enabled := FALSE;
  SPDEL.Enabled := FALSE;
end;

procedure TUMGR.SPDELClick(Sender: TObject);

var FileName: string;

begin
    FileName := TFLB.Filename;
    if (FileName <> '') and (MessageDlg('Are you sure?',
       'Delete file '''+ ExtractFileName(FileName)+'''?',mtConfirmation,
       [mbYES, mbNO],0) = mrYES) then begin
         DeleteFile(Filename);
         TFLB.UpdateFileList;
       end;
end;

procedure TUMGR.SPRENClick(Sender: TObject);

begin
  FNEWN.EDNEWN.Text := ExtractFileName(TFLB.Filename);
  FNEWN.Show;
end;

procedure TUMGR.TFLBSelectionChange(Sender: TObject; User: boolean);
begin
   SPREN.Enabled := TRUE;
   SPDEL.Enabled := TRUE;

end;

initialization
  {$I umanager.lrs}

end.

