//
// PCB-mount potentiometer (pot.lbr POT)
// LB10 10-LED bar (standard led.lbr LB10) 
// Horizontal-mount xtal (standard special.lbr XTAL)
// I1EPJ 2004
//
#macro POT_pin(a,b,c)

// Un piedino del potenziometro
union {
	box { <a-1, b, c-0.2>, <a+1, b-5, c+0.2> }
	box { <a-0.5, b-5, c-0.2>,<a+0.5, b-10, c+0.2> }
	texture { col_silver }
}

#end

#macro POT_fix(a,b,c,r)
	difference {
		box { 
			<-1.5, -1.5, -1.5>, <1.5, 1.5, 1.5 >
			texture { col_silver }
		}
		box { 
			<-1, -1.5, -1>,<1.5, 1.5, 1.5 > 
			texture { col_silver }
		}
		rotate <0,0,r> translate <a,b,c>
    	}
#end

#macro POT_nut(a,b,c)
	union {
		difference {
			prism {
	          		linear_spline
	          		0,2,6
	          		<0,8>,<7,4>,<7,-4>,<0,-8>,<-7,-4>,<-7,4>
			}
			cylinder {
	          		<0,-0.1,0>,<0,2.1,0>,4.7
			}
          	}
		texture { col_silver }
		rotate <90,0,0> translate <a,b,c>
	}
#end

//
// Potenziometro da circuito stampato
// pot.lbr POT
//
#macro POT(value)
	union {
		// il corpo metallico
		difference {
			cylinder { 
				<0,0,0>,<0,0,6>,10.5 
				texture { col_silver }
			}
			box { 
				<-1.5, 8.5, 4>, <1, 10.5, 6> rotate <0,0,15>
				texture { col_silver }
			}
    		}
    
		POT_fix(-8.2,-3.5,-1.0, 25)
		POT_fix(-8.2, 3.5,-1.0,-25)
		POT_fix( 8.2,-3.5,-1.0,-25)
		POT_fix( 8.2, 3.5,-1.0, 25)

		// valore 
		text {
			ttf besch_font value 1, 0 pigment { Black }
			scale <2,2,2> rotate <90,0,0> translate<-1.5,10.5,2.5>
		}

		// parte plastica anteriore
		union { 
			cylinder { <0,0,0>,<0,0,-2>,10 }
			box { <-8.5,0,0>,<8.5,-12,-2> }
			texture { pigment{Gray20} }
		}
		cylinder {
			<0,0,-2>,<0,0,-3>, 7
			texture { pigment{Gray20} }
		}
		cylinder { 
			<0,0,-3>,<0,0,-10>, 5
			texture { 
				pigment{ 
					spiral1 1 color_map { 
						[0.5 color Black]
						[0.5 color Gray20]
					}
				}
			}
	    	}
		cylinder { 
			<0,0,-10>,<0,0,-52>,3
			texture { pigment{Gray20} } 
		}

		// parte plastica posteriore
		difference {
			cylinder {
				<0,0,6>,<0,0,7>,3
				texture { pigment{Gray20} } 
			}
			box { 
				<-2.5,-0.75,6.05>, <2.5,0.75,7.05>
				rotate <0,0,45>
				texture { pigment{Gray20} } 
			}
	
		}
		// piedini
		POT_pin(-5.08,-8,0)
		POT_pin(0,-8,0)
		POT_pin(5.08,-8,0)

		// dado
		POT_nut(0,0,-8)
	}
	translate <5.08,13,0>
#end

//-----------------------------------------------------------------

//
// LB10 10-LED BAR
// LED.LBR LB10
//

#macro LB10_led(a,b,c)
	box {
		<-0.9, -5, -2.5>, <0.9, 0, 2.5>
		texture { pigment {Gray60}}
		translate <a,b,c>
	}
#end

#macro LB10_pin(a,b,c)
	box {
		<-0.25, 0, -0.25>, <0.25, -6.6, 0.25>
		texture { col_silver }
		translate <a,b,c>
	}
#end

#macro LB10(value)

	#local i = 0;

	union {
		difference {
			union {
				box {
					<0, 8.1, 0>, <25.5, 8.2, 10.2>
					texture { pigment{ Gray40 } }
				}
				box {
					<0, 0, 0>, <25.5, 8.1, 10.2>
					texture { pigment{ White } }
				}
			}
			prism {
	          		linear_spline
	          		-0.1,8.3,4
	          		<-0.1,-0.1>,<-0.1,1>,<1,-0.1>,<-0.1,-0.1>
				pigment{White}
			}
		}
		#while (i < 10)
			LB10_pin(1.5+2.54*i, 0, 1.3)
			LB10_pin(1.5+2.54*i, 0, 8.92)
			LB10_led(1.3+2.54*i, 8.3, 5.1)
			#local i=i+1;
		#end
		text {
			ttf besch_font value 1, 0 pigment { Black }
			scale <2,2,1> rotate <0,180,0> translate<15,4.1,10.21>
		}
	}
	translate <-12.75, 0.5, -5.1>
#end

//Quarz mit vernderbarer Hhe und 4,9mm Pitch
//basiert auf Modell von Andreas Fecht <info@aftec.de>
//Horizontal-mount version by i1epj
#macro HC18U_H(value,hight)
union{
cylinder{<-3.35,0,0><-3.35,0.7,0>2.25}
cylinder{<3.35,0,0><3.35,0.7,0>2.25}
box{<-3.35,0,-2.25><3.35,0.7,2.25>}
cylinder{<-3.35,0.7,0><-3.35,hight,0>2}
cylinder{<3.35,0,0><3.35,hight,0>2}
box{<-3.35,0,-2><3.35,hight,2>}
torus{1.6,0.4 translate<-3.35,hight,0>}
torus{1.6,0.4 translate<3.35,hight,0>}
cylinder{<-3.35,0,0><3.35,0,0>0.4 translate<0,hight,-1.6>}
cylinder{<-3.35,0,0><3.35,0,0>0.4 translate<0,hight,1.6>}
cylinder{<-3.35,hight,0><-3.35,hight+0.4,0>1.6}
cylinder{<3.35,hight,0><3.35,hight+0.4,0>1.6}
box{<-3.35,hight,-1.6><3.35,hight+0.4,1.6>}
cylinder{<-2.45,0,0>, <-2.45,-1.75,0>, 0.25}
cylinder{<2.45,0,0>,<2.45,-1.75,0>, 0.25}
cylinder{<-2.45,-1.5,0>, <-2.45,-1.5,3>, 0.25}
cylinder{<2.45,-1.5,0>,<2.45,-1.5,3>, 0.25}
cylinder{<-2.45,-0.25,0>, <-2.45,0,0>, 1 texture{pigment{Black}}}
cylinder{<2.45,-0.25,0>, <2.45,0,0>, 1 texture{pigment{Black}}}
#if(hight>5)
text {ttf besch_font value 0.1, 0 pigment{Black} scale 1.5 translate<-3,hight/2,-2.01>}
#else
text {ttf besch_font value 0.1, 0 pigment{Black} scale 2 rotate<90,0,0> translate<-4,hight+0.401,-0.5>}
#end
texture{col_silver}
rotate <90,0,0>
translate <0, 1.75, -hight/2>
}
#end
